// Autor: Ivan Katanic

#include <algorithm>
#include <cassert>
#include <cstring>
#include <iostream>

using namespace std;

#define FOR(i, a, b) for (int i = (a); i < (b); ++i)
#define REP(i, n) FOR(i, 0, n)
#define TRACE(x) cout << #x << " = " << x << endl
#define _ << " _ " <<

typedef long long llint;

vector<string> tones = {"C", "C#", "D", "D#", "E", "F", "F#", "G", "G#", "A", "A#", "H"};
vector<string> basic = {"E4", "H3", "G3", "D3", "A2", "E2"};

int main(void) {
  vector<string> all;
  FOR(i, 1, 100) {
    for (string t : tones) {
      all.push_back(t + to_string(i));
    }
  }
  
  vector<string> a;
  REP(i, 6) {
    char buff[1111];
    scanf("%s", buff);
    a.push_back(buff);
  }

  
  int n = a[0].size();
  FOR(i, 1, n-1) {
    REP(j, 6) {
      if (isdigit(a[j][i])) {
        int k = i, x = 0;
        while (k < n-1 && isdigit(a[j][k])) {
          x = x * 10 + a[j][k]-'0';
          a[j][k++] = '-';
        }

        auto it = find(all.begin(), all.end(), basic[j]) + x;
        puts(it->c_str());
      }
    }
  }
  return 0;
}
